from linebot.models import VideoSendMessage, ImageSendMessage, MessageEvent, TextMessage, TextSendMessage
from .. import redis_client
from app.models.tables import Response


def reply(text):
    # if 打開 switch=true 關閉 switch=false
    switch = None
    if '打開' in text:
        switch = True
    elif '關閉' in text:
        switch = False
    # print("on" if switch else "off")
    if switch != None:
        # print("send to redis")
        if '客廳電燈開關1' in text:
            redis_client.set('light1', int(switch))
            # print("send done")
        elif '客廳電燈開關2' in text:
            redis_client.set('light2', int(switch))
            # print("send done")
        else:
            return TextSendMessage(text='無此設備')
        return TextSendMessage(text="已發送指令")
    if "template" in text:  # text == "template_xxxxx_xxx:<number>"
        template = text.split(":")[0]
        number = text.split(":")[1]
        response = Response.query.filter_by(get=template).first()
        if response:
            return TextSendMessage(text=response.response.replace("\\n", "\n").replace("GGG", number))
    response = Response.query.filter_by(get=text).first()
    if response:
        if response.type == 0:
            return TextSendMessage(text=response.response.replace("\\n", "\n"))
        elif response.type == 1:
            return ImageSendMessage(
                original_content_url=response.response,
                preview_image_url=response.response
            )
        elif response.type == 2:
            return VideoSendMessage(
                original_content_url=response.response,
                preview_image_url=response.response
            )
        elif response.type == 98:  # huminity
            temp = str(redis_client.get('humidity')).replace(
                "b'", '').replace("'", '')
            text = response.response.replace(
                'GGG', temp)
            return TextSendMessage(text=text)
        elif response.type == 99:  # temperture
            temp = str(redis_client.get('temperature')).replace(
                "b'", '').replace("'", '')
            text = response.response.replace(
                'GGG', temp)
            return TextSendMessage(text=text)

    # cursor = mydb.cursor()
    # try:
    #     query = "SELECT `type`, `out` FROM `linereplay` WHERE `enter` = %s"
    #     values = (text,)
    #     cursor.execute(query, values)
    #     result = cursor.fetchone()

    #     if result:
    #         msg_type, reply_msg = result
    #         reply_msg = reply_msg.replace("\\n", "\n")
    #         if msg_type == 0:
    #             return TextSendMessage(text=reply_msg)
    #         elif msg_type == 1:
    #             return ImageSendMessage(
    #                 original_content_url=reply_msg,
    #                 preview_image_url=reply_msg
    #             )
    #         elif msg_type == 2:
    #             return VideoSendMessage(
    #                 original_content_url=reply_msg,
    #                 preview_image_url=reply_msg
    #             )
    #         elif msg_type == 3:
    #             # cursor = mydb.cursor()
    #             query = "SELECT `float` FROM `vardata` WHERE `name` = %s"
    #             values = (text,)
    #             cursor.execute(query, values)
    #             result = cursor.fetchone()
    #             if result:
    #                 fl = float(result[0])
    #                 return TextSendMessage(text=reply_msg.replace('GGG', str(fl)))
    #     return TextSendMessage(text=text)
    # except Exception as e:
    #     return TextSendMessage(text="error"+str(e))
    # finally:
    #     cursor.close()
